/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.handler;

import com.chaosthedude.realistictorches.RealisticTorches;
import com.chaosthedude.realistictorches.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class LightSourceHandler {
    public static List<Item> lightSources = new ArrayList<Item>();

    public static void registerLightSources() {
        int lightSourceBlocks = 0;
        if (ConfigHandler.registerLightSourceBlocks) {
            for (Block block : Block.field_149771_c) {
                if (block.func_149750_m(block.func_176223_P()) <= ConfigHandler.lightSourceRegistryThreshold) continue;
                lightSources.add(Item.func_150898_a((Block)block));
                ++lightSourceBlocks;
            }
        } else {
            for (String blockName : ConfigHandler.lightSourceItems) {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) continue;
                lightSources.add(Item.func_150898_a((Block)block));
                ++lightSourceBlocks;
            }
        }
        int lightSourceItems = 0;
        for (String itemName : ConfigHandler.lightSourceItems) {
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
            if (item == null) continue;
            lightSources.add(item);
            ++lightSourceItems;
        }
        RealisticTorches.logger.info("Registered " + lightSourceBlocks + " blocks and " + lightSourceItems + " items as light sources.");
    }

    public static boolean isLightSource(Item item) {
        return lightSources.contains(item);
    }

    public static boolean containsLightSource(Iterable<ItemStack> items) {
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack.func_190926_b() || !LightSourceHandler.isLightSource(stack.func_77973_b())) continue;
                return true;
            }
        }
        return false;
    }
}

